# first time only: install R/qtl
install.packages("qtl")

# load library and connect to molgenis
library(qtl)
source("https://molgenis83.gcc.rug.nl/molgenis.R")
molgenis.login("admin", "mrdemo")

# download and setup data
yeastdata <- molgenis.get("base_yeast_geno_pheno_map")
tmpfile <- tempfile("tmp_yeastdata")
yeastdata <- yeastdata[with(yeastdata, order(chr,na.last = FALSE)), ]
write.table(yeastdata, tmpfile, sep = ",", col.names = FALSE, row.names = FALSE, quote = FALSE, na = "")

# read data and plot genotypes
yeast <- read.cross(format="csvr", file=tmpfile, genotypes=c("1","2"))
yeast <- calc.genoprob(yeast)
yeast <- fill.geno(yeast)
geno.image(yeast)

# perform qtl scan on the first phenotype
result_hk <- scanone(yeast, pheno.col=1, method="hk")
perm_hk <- scanone(yeast, pheno.col=1, method="hk", n.perm=1000)
plot(result_hk)
abline(h=summary(perm_hk)[[1]],col="green",lty=2,lwd=2)
abline(h=summary(perm_hk)[[2]],col="orange",lty=2,lwd=2)

# get top marker and plot gene expression
topmarker <- find.marker(yeast, chr=max(result_hk)$chr, pos=max(result_hk)$pos)
plotPXG(yeast, marker=topmarker)

# logout
molgenis.logout()
